
// BIRetainer.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*! 
    @class       BIRetainer
    @abstract    BIRetainer represents a retainer received by the client.
    @discussion  A retainer is an amount of money given to the user upfront by a client.  This money will be applied to work done as work progresses.
*/



#ifdef BILLINGS_PRO
#import "_BPRetainer.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIRetainer.h"
#endif
#import "BIAppVersioning.h"


@class BIPaymentMethodType, BIDatabaseObjectContext;

@interface BIRetainer : BL_SUPER_CLASSNAME_MUNGE(Retainer) 
{
}

+ (NSDecimalNumber *)calculateBalanceUsingRetainers:(NSArray *)retainers payments:(NSArray *)payments;

- (BIPaymentMethodType*)defaultPaymentMethodUsingObjectContext:(BIDatabaseObjectContext*)oc;

- (NSNumber*)balance;
- (void)setBalance:(NSNumber*)aBal;

- (NSString*)methodString;

- (NSCalendarDate *)dateForAccount;

- (NSNumberFormatter *)currencyFormatter;

// If paid in actual base currency, returns that. If total is in base currency, returns that. Otherwise returns nil.
- (NSNumber *)baseTotal;
// if all else fails, applies the conversion rate
- (NSNumber *)exchangedBaseTotal;


- (NSString *)temporaryRetainerHistoryOnInvoiceTitle;
- (NSNumber *)temporaryRetainerHistoryOnInvoiceDisbursement;
- (NSNumber *)temporaryRetainerHistoryOnInvoiceAmount;


@end
